package jcircus.gui;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jcircus.util.ProcInfo;

/**
 * ChooseMainDialog.java
 *
 * Dialog where the user selects the processes for which they want to
 * create a main class.
 *
 * @author  Angela Freitas
 */
public class ChooseMainDialog extends JDialog implements ActionListener {
    
    private JCheckBox[] checkBoxes;
    private JButton btnOk;
    private JButton btnCancel;
    private List<ProcInfo> procList;
    
    /**
     * Constructor
     */
    public ChooseMainDialog(JCircusFrame jCircusFrame, List<ProcInfo> procList) {
        
        super(jCircusFrame, "Choose main processes", true);
        this.procList = procList;

        // User can not close by clicking on "X"
        this.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
      
        //Create and set up the content pane.
        JComponent contentPane = new JPanel();
        contentPane.setOpaque(true); //content panes must be opaque
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setContentPane(contentPane);
        
        this.getContentPane().setLayout(
                new BoxLayout(this.getContentPane(), BoxLayout.Y_AXIS));
        
        String[] text = new String[] {
            "Mark the processes for which you",
            "want a class Main to be created:"
        };
        checkBoxes = new JCheckBox[procList.size()];
        
        int i;
        for (i = 0; i < text.length; i++) {
            this.getContentPane().add(new JLabel(text[i]));
        }
        for (i = 0; i < checkBoxes.length; i++) {
            checkBoxes[i] = new JCheckBox(procList.get(i).getProcessName());
            this.getContentPane().add(checkBoxes[i]);
        }
        
        JPanel pnlButtons = new JPanel();
        //pnlButtons.setLayout(new GridLayout(0, 2));
        btnOk = new JButton("OK");
        btnOk.setSize(20, 10);
        btnOk.addActionListener(this);
        pnlButtons.add(btnOk);

        btnCancel = new JButton("Cancel");
        btnCancel.setSize(20, 10);
        btnCancel.addActionListener(this);
        pnlButtons.add(btnCancel);
        
        this.getContentPane().add(pnlButtons);
        
    }
    
    /**
     *
     */
    public void actionPerformed(ActionEvent e) {
    
        if (e.getSource() == btnOk) {
            btnOkPressed();
        } else if (e.getSource() == btnCancel) {
            btnCancelPressed();
        }
    }
    
    /**
     *
     */
    private void btnOkPressed() {
    
        int n = 0;
        for (int i = 0; i < checkBoxes.length; i++) {
            
            if (checkBoxes[i].isSelected()) {
                procList.get(i).setCreateMain(true);
                n++;
            } else {
                procList.get(i).setCreateMain(false);
            }
        }
        
        if (n == 0) {
            JOptionPane.showMessageDialog(this, "No class Main will be created.");
        }
        
        ((JCircusFrame) this.getOwner()).setCanceled(false);
        this.setVisible(false);
        this.dispose();
        
    }
    
    /**
     *
     */
    private void btnCancelPressed() {

        ((JCircusFrame) this.getOwner()).setCanceled(true);
        this.setVisible(false);
        this.dispose();
    }
    
}
